package com.ejie.ab04b.control;

import com.ejie.ab04b.service.TipoObraService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.TipoObra;

/**
 * TipoObraController generated by UDA, 22-feb-2017 9:43:19.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/tipoObra")

public class TipoObraController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoObraController.class);

	@Autowired()
	private TipoObraService tipoObraService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  tipobr070
	 *            String
	 *
	 * @param tipobr070 the tipobr 070
	 *  TipoObra Objeto correspondiente al identificador indicado.
	 * @return the tipo obra
	 */
	@RequestMapping(value = "/{tipobr070}", method = RequestMethod.GET)
	public @ResponseBody TipoObra get(@PathVariable String tipobr070) {
		TipoObra tipoObra = new TipoObra();
		tipoObra.setTipobr070(tipobr070);
		tipoObra = this.tipoObraService.find(tipoObra);
		TipoObraController.logger
				.info("[GET - findBy_PK] : Obtener Ab0470s00 por PK");
		return tipoObra;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterTipoObra
	 *            TipoObra Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 *
	 * @param filterTipoObra the filter tipo obra
	 *  List<TipoObra> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoObra> getAll(
			@ModelAttribute TipoObra filterTipoObra) {
		TipoObraController.logger
				.info("[GET - find_ALL] : Obtener TipoObra por filtro");
		return this.tipoObraService.findAll(filterTipoObra, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  tipoObra
	 *            TipoObra Bean que contiene la informacion a modificar.
	 *
	 * @param tipoObra the tipo obra
	 *  TipoObra Bean resultante de la modificacion.
	 * @return the tipo obra
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TipoObra edit(@RequestBody TipoObra tipoObra) {
		TipoObra tipoObraAux = this.tipoObraService.update(tipoObra);
		TipoObraController.logger
				.info("[PUT] : TipoObra actualizado correctamente");
		return tipoObraAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  tipoObra
	 *            TipoObra Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 *
	 * @param tipoObra the tipo obra
	 *  TipoObra Bean resultante del proceso de creacion.
	 * @return the tipo obra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoObra add(@RequestBody TipoObra tipoObra) {
		TipoObra tipoObraAux = this.tipoObraService.add(tipoObra);
		TipoObraController.logger
				.info("[POST] : TipoObra insertado correctamente");
		return tipoObraAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  tipobr070
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param tipobr070 the tipobr 070
	 *  TipoObra Bean eliminado.
	 * @return the tipo obra
	 */
	@RequestMapping(value = "/{tipobr070}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TipoObra remove(@PathVariable String tipobr070) {
		TipoObra tipoObra = new TipoObra();
		tipoObra.setTipobr070(tipobr070);
		this.tipoObraService.remove(tipoObra);
		TipoObraController.logger
				.info("[DELETE] : TipoObra borrado correctamente");
		return tipoObra;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		TipoObraController.logger.info("[GET - View] : tipoobra");
		return "tipoobra";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterTipoObra
	 *            TipoObra Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<TipoObra> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<TipoObra> filter(
			@RequestJsonBody(param = "filter") TipoObra filterTipoObra,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoObraController.logger.info("[POST - filter] : Obtener TipoObra");
		return this.tipoObraService.filter(filterTipoObra, jqGridRequestDto,
				false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterTipoObra
	 *            TipoObra Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  searchTipoObra
	 *            TipoObra Bean que contiene los parametros de busqueda a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param searchTipoObra the search tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<TipoObra> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<TipoObra>> search(
			@RequestJsonBody(param = "filter") TipoObra filterTipoObra,
			@RequestJsonBody(param = "search") TipoObra searchTipoObra,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoObraController.logger.info("[POST - search] : Buscar TipoObra");
		return this.tipoObraService.search(filterTipoObra, searchTipoObra,
				jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterTipoObra            TipoObra Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") TipoObra filterTipoObra,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoObraController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples TipoObra");
		this.tipoObraService.removeMultiple(filterTipoObra, jqGridRequestDto,
				false);
		TipoObraController.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterTipoObra            Expediente Bean que contiene los parÃ¡metros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap            ModelMap
	 *  columns            String
	 *  request            HttpServletRequest
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(@ModelAttribute() TipoObra filterTipoObra,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<TipoObra> listTipoObra = this.tipoObraService
				.findAllLike(filterTipoObra, jqGridRequestDto, false);

		// GENERAMOS EL FICHERO
		UtilidadesWar
				.generateReport(modelMap,
						Utilities.getLiteralMessage(this.messageSource,
								"excel.titulo.tiposObra"),
						columns, listTipoObra);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}

}
